{
  description = "My Flake";

  inputs = {
    nixpkgs.url = "github:nixos/nixpkgs?ref=nixos-unstable";

    # Home-manager setup
    home-manager = {
      url = "github:nix-community/home-manager";
      inputs.nixpkgs.follows = "nixpkgs";
    };

    # Hyprland url flake 
    # hyprland.url = "git+https://github.com/hyprwm/Hyprland?submodules=1";

    # Gruvbox GRUB theme
    tartarus-grub = {
      url = "github:AllJavi/tartarus-grub";
      flake = false;
    };

    # Catppuccin-bat
    gruvbox-bat = {
      url = "github:molchalin/gruvbox-material-bat";
      flake = false;
    };

    # Nix colors for a good and easy rice
    nix-colors.url = "github:misterio77/nix-colors";

    # AGS for awesome widgets
    ags.url = "github:Aylur/ags";

    # Neovim toggleterm plugin by akinsho
    plugin-terminal = {
      url = "github:akinsho/toggleterm.nvim";
      flake = false;
    };
  };

  outputs = { self, nixpkgs, home-manager, ... }@inputs:
    let
      system = "x86_64-linux";
      pkgs = import inputs.nixpkgs {
        inherit system;
        overlays = [
          (final: prev: {
            cliphist = prev.cliphist.overrideAttrs (old: {
              version = "0.6.1";
              src = prev.fetchFromGitHub {
                owner = "sentriz";
                repo = "cliphist";
                rev = "refs/tags/v${version}";
                hash = "sha256-tImRbWjYCdIY8wVMibc5g5/qYZGwgT9pl4pWvY7BDlI=";
              };
              vendorHash =
                "sha256-gG8v3JFncadfCEUa7iR6Sw8nifFNTciDaeBszOlGntU=";

              passthru = { updateScript = nix-update-script { }; };
            });
          })
        ];
      };
    in {
      nixosConfigurations = {
        mynixos = nixpkgs.lib.nixosSystem {
          inherit system pkgs;
          specialArgs = { inherit inputs; };

          modules = [
            ./host

            home-manager.nixosModules.home-manager
            {
              home-manager = {
                useGlobalPkgs = true;
                useUserPackages = true;
                extraSpecialArgs = { inherit inputs; };
                users."chris" = import ./home;
              };
            }
          ];
        };
      };
    };
}
