  programs.tmux = {
    enable = true;
    shortcut = "a";

    plugins = with pkgs.tmuxPlugins; [ vim-tmux-navigator ];

    terminal = "screen-256color";
    baseIndex = 1;
    keyMode = "vi";
    mouse = true;
    aggressiveResize = false;
    clock24 = true;
    escapeTime = 500;
    historyLimit = 5000;

    sensibleOnTop = false;
    extraConfig =
      let
        binds = [
          {
            key = "|";
            options = "";
            command = "split-window -h";
          }
          {
            key = "-";
            options = "";
            command = "split-window -v";
          }
          {
            key = "h";
            options = "-r";
            command = "resize-pane -L 5";
          }
          {
            key = "j";
            options = "-r";
            command = "resize-pane -D 5";
          }
          {
            key = "k";
            options = "-r";
            command = "resize-pane -U 5";
          }
          {
            key = "l";
            options = "-r";
            command = "resize-pane -R 5";
          }
          {
            key = "m";
            options = "-r";
            command = "resize-pane -Z";
          }
        ];

        unbinds = [
          "%"
          "\""
        ];

        bindKey = [
          "-T copy-mode-vi 'v' send -X begin-selection"
          "-T copy-mode-vi 'y' send -X copy-selection"
        ];

        bindConfig =
          lib.lists.forEach binds (i: "bind ${i.key} ${i.options} ${i.command}")
          ++ lib.lists.forEach unbinds (i: "unbind ${i}")
          ++ lib.lists.forEach bindKey (i: "bind-key ${i}");
      in
      lib.concatLines bindConfig;
  };
