  programs.tmux = {
    enable = true;
    shortcut = "a";

    plugins = with pkgs.tmuxPlugins; [ vim-tmux-navigator ];

    terminal = "screen-256color";
    baseIndex = 1;
    keyMode = "vi";
    mouse = true;
    aggressiveResize = false;
    clock24 = true;
    escapeTime = 500;
    historyLimit = 5000;

    sensibleOnTop = false;
    extraConfig = let
      binds = [
        { key = "|", command = "split-window -h" }
        { key = "-", command = "split-window -v" }
        { key = "h", options = "-r", command = "resize-pane -L 5" }
        { key = "j", options = "-r", command = "resize-pane -D 5"}
        { key = "k", options = "-r", command = "resize-pane -U 5"}
        { key = "l", options = "-r", command = "resize-pane -R 5"}
        { key = "m", options = "-r", command = "resize-pane -Z"}
      ];
    in
    ''
      ${lists.forEach binds (i: "bind ${i.key} ${i.options} ${i.command}")}
    '';
  };